// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/decal_group.hh"

using namespace nv;


decal_group_manager::decal_group_manager( context* a_context )
	: m_context( a_context )
{

}

decal_group decal_group_manager::create_group( uint32 max_particles )
{
	decal_group result = m_groups.create();
	decal_group_info* info = m_groups.get( result );
	info->local = false;
	info->count = 0;
	info->quota = max_particles;
//	info->vtx_buffer = m_context->create_buffer( VERTEX_BUFFER, STREAM_DRAW, info->quota * sizeof( particle_quad )/*, info->quads_[0].data*/ );
// 	vertex_array_desc desc;
// 	desc.add_vertex_buffers< de >( info->vtx_buffer, true );
// 	info->vtx_array = m_context->create_vertex_array( desc );
// 	info->quads = new particle_quad[info->quota];
	info->ref_counter = 0;
	return result;
}

void decal_group_manager::release( decal_group group )
{
	if ( decal_group_info* info = m_groups.get( group ) )
	{
		release( info );
		m_groups.destroy( group );
	}
}

void decal_group_manager::release( decal_group_info* info )
{
	if ( info )
	{
		delete[] info->quads;
		m_context->release( info->vtx_array );
	}
}


void decal_group_manager::clear()
{
	for ( auto& g : m_groups )
		release( &g );
}

bool decal_group_manager::ref( decal_group group )
{
	decal_group_info* info = m_groups.get( group );
	if ( !info ) return false;
	info->ref_counter++;
	return true;
}

bool decal_group_manager::unref( decal_group group )
{
	decal_group_info* info = m_groups.get( group );
	if ( !info ) return false;
	info->ref_counter--;
	return true;
}

