// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_vertex_buffer.hh"

#include "nv/lib/gl.hh"
#include "nv/gl/gl_enum.hh"

using namespace nv;

gl_vertex_buffer::gl_vertex_buffer( buffer_hint hint, int size, void* data ) 
	: vertex_buffer( hint, size ), m_name()
{
	if (data)
	{
		assign( data );
	}
}

void gl_vertex_buffer::assign( void* data )
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
	glBufferData( GL_ARRAY_BUFFER, m_size, data, buffer_hint_to_enum( m_hint ) );
	glBindBuffer( GL_ARRAY_BUFFER, 0);
}

void gl_vertex_buffer::assign( void* data, int offset, int size )
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
	glBufferSubData( GL_ARRAY_BUFFER, offset, size, data );
	glBindBuffer( GL_ARRAY_BUFFER, 0);
}


void gl_vertex_buffer::bind()
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
}

void gl_vertex_buffer::unbind()
{
	glBindBuffer( GL_ARRAY_BUFFER, 0 );
}

bool gl_vertex_buffer::is_valid() const
{
	return m_name.is_valid();
}

gl_index_buffer::gl_index_buffer( buffer_hint hint, int size, void* data ) 
	: index_buffer( hint, size ), m_name()
{
	if (data)
	{
		assign( data );
	}
}

void gl_index_buffer::assign( void* data )
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, m_name.get_value() );
	glBufferData( GL_ELEMENT_ARRAY_BUFFER, m_size, data, buffer_hint_to_enum( m_hint ) );
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, 0);
}

void gl_index_buffer::assign( void* data, int offset, int size )
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, m_name.get_value() );
	glBufferSubData( GL_ELEMENT_ARRAY_BUFFER, offset, size, data );
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, 0);
}

void gl_index_buffer::bind()
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, m_name.get_value() );
}

void gl_index_buffer::unbind()
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, 0 );
}

bool gl_index_buffer::is_valid() const
{
	return m_name.is_valid();
}

gl_vertex_array::gl_vertex_array()
{

}

void gl_vertex_array::bind()
{
	for ( vertex_buffer_attribute_map::iterator i = m_map.begin(); 	i != m_map.end(); ++i ) 
	{
		int location                = i->first;
		vertex_buffer_attribute* va = i->second;
		vertex_buffer*           vb = va->get_buffer();
		glEnableVertexAttribArray( location );
		vb->bind();
		glVertexAttribPointer( 
			location, 
			va->get_components(), 
			nv::datatype_to_gl_enum( va->get_datatype() ),
			GL_FALSE,
			va->get_stride(),
			(void*)va->get_offset()
			);
		vb->unbind();
	}

}

void gl_vertex_array::unbind()
{
	for ( vertex_buffer_attribute_map::iterator i = m_map.begin(); 	i != m_map.end(); ++i ) 
	{
		glDisableVertexAttribArray( i->first );
	}
}
