// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file image_data.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Image data struct
 */

#ifndef NV_IMAGE_DATA_HH
#define NV_IMAGE_DATA_HH

#include <algorithm>
#include <nv/common.hh>
#include <glm/glm.hpp>

namespace nv
{
	class image_data
	{
	public:
		image_data( glm::ivec2 size, size_t depth, const uint8 * data ) 
			: m_size( size ), m_depth( depth ), m_data( nullptr )
		{ 
			std::size_t bsize = m_size.x * m_size.y * m_depth;
			m_data = new uint8[ bsize ]; 
			std::copy( data, data + bsize, m_data );
		}
		uint8* release_data() { uint8* r = m_data; m_data = nullptr; return r; }
		const uint8 * get_data()    const { return m_data; }
		const glm::ivec2 get_size() const { return m_size; }
		const size_t get_depth()    const { return m_depth; }
		~image_data() {	if (m_data) delete m_data; }
	private:
		glm::ivec2 m_size;  //< Defines the size of the image as a vector
		size_t     m_depth; //< Defines the depth of the image
		uint8*     m_data;  //< Holder for data
	};
}

#endif // NV_IMAGE_DATA_HH
