// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file io_event.hh
 * @author Kornel Kisielewicz
 * @brief 
 */

#ifndef NV_IO_EVENT_HH
#define NV_IO_EVENT_HH

#include <nv/common.hh>
#include <nv/types.hh>

namespace nv
{

	// Generate the key_code enum
	enum key_code
	{
#	define NV_KEY( id, val ) id = val,
#		include <nv/detail/key_list.inc>
#	undef NV_KEY
	};
	NV_REGISTER_NAME( key_code );

	// Generate the mouse_code enum
	enum mouse_code
	{
#	define NV_MOUSE( id, val ) id = val,
#		include <nv/detail/mouse_list.inc>
#	undef NV_MOUSE
	};
	NV_REGISTER_NAME( mouse_code );

	// Generate the io_event_code enum
	enum io_event_code
	{
#	define NV_IO_EVENT( id ) id,
#		include <nv/detail/io_event_list.inc>
#	undef NV_IO_EVENT
	};
	NV_REGISTER_NAME( io_event_code );

	struct key_event
	{
		/// Input event ASCII code
		char8 ascii;

		/// Input event local code
		key_code code;

		/// True if shift key is present
		bool shift;

		/// True if control key is present
		bool control;

		/// True if alt key is present
		bool alt;

		/// True if pressed
		bool pressed;
	};
	NV_REGISTER_NAME( key_event );

	struct mouse_button_event
	{
		uint16 x;
		uint16 y;
		///
		uint32 button;
		/// True if pressed
		bool pressed;
		/// Mouse button code
		mouse_code code;
	};
	NV_REGISTER_NAME( mouse_button_event );

	struct mouse_move_event
	{
		uint16 x;
		uint16 y;
		sint16 rx;
		sint16 ry;
		/// True if pressed
		bool pressed;
		/// Mouse button code
		mouse_code code;
	};
	NV_REGISTER_NAME( mouse_move_event );

	struct system_event
	{
		uint8  sys_type;
		uint32 param1;
		uint32 param2;
	};
	NV_REGISTER_NAME( system_event );

	struct input_event
	{
		io_event_code type;
		union
		{
			key_event          key;
			mouse_button_event mbutton;
			mouse_move_event   mmove;
			system_event       system;
		};
	};
	NV_REGISTER_NAME( input_event );

	const char* get_key_name( key_code key );
	const char* get_mouse_name( mouse_code button );
	const char* get_io_event_name( io_event_code event );
	void register_io_types( type_database* db );
}

#endif // NV_IO_EVENT_HH
