// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gui_menu.hh
 * @author Kornel Kisielewicz
 * @brief GUI menu
 */

#ifndef NV_GUI_MENU_HH
#define NV_GUI_MENU_HH

#include <nv/common.hh>
#include <nv/stl/handle.hh>
#include <nv/stl/flags.hh>
#include <nv/gui/gui_common.hh>
#include <nv/gui/gui_environment.hh>

namespace nv
{

	namespace gui
	{

		template < typename T = void*>
		struct menu_option
		{
			string_view name;
			string_view klass;
			T data;
			flags f;
		};

		template < typename T = void* >
		inline handle create_menu( environment* env, rectangle r, handle parent, 
			array_view< menu_option > options, 
			const function< void( T ) >& on_activate,
			const function< void( T ) >& on_select
			)
		{
			handle result = env->create_element( parent, r );

		}

	}
}

#endif // NV_GUI_MENU_HH
