// Copyright (C) 2015-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_FORMATS_NDFM_LOADER_HH
#define NV_FORMATS_NDFM_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/stl/vector.hh>
#include <nv/stl/string_table.hh>

namespace nv
{

	struct ndf_header
	{
		uint32  id;
		uint32  version;
	};

	struct ndf_element
	{
		shash64 name;
		shash64 type;
		uint32  flags;
		uint32  size;
		uint16  attributes;
		uint16  children;
	};

	enum class ndf_datatype : uint16
	{
		STRING,
		INTEGER,
		FLOAT
	};

	struct ndf_attribute
	{
		shash64      key;
		ndf_datatype type;
		uint8        data[22];
	};

	static_assert( sizeof( ndf_attribute ) == 32, "alignment issue!" );

	struct ndfm_node_data
	{
		mat4     transform;
		sint16   parent_id;
	};

	struct ndfm_animation_data
	{
		uint16 frame_rate;
		uint16 frame_count;
	};

	struct ndfm_channel_header
	{
		data_descriptor format;
		uint32          count;
	};

#if 0

	class ndfm_loader : public mesh_loader
	{
	public:
		explicit ndfm_loader( string_table* strings ) : mesh_loader( strings ), m_node_data( nullptr ) {}
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( uint32 index = 0 );
		virtual uint32 get_nodes_data_count() const { return 1; }
		virtual mesh_nodes_data* release_mesh_nodes_data( uint32 = 0 );
		virtual data_node_list* release_data_node_list( uint32 = 0 );
		virtual bool is_animated( uint32 = 0 );
		virtual uint32 get_mesh_count() const { return m_meshes.size(); }
		virtual ~ndfm_loader();
	private:
		void reset();
		void skip_attributes( stream& source, uint32 count );
		bool load_mesh( stream& source, const ndf_element& e );
		bool load_strings( stream& source );
		bool load_animation( stream& source, const ndf_element& e );
		bool load_channel( stream& source, data_channel_set* channel_set );
		bool load_channel_set( stream& source, data_channel_set* channel_set, const ndf_element& e );

		mesh_nodes_data*            m_node_data;
		vector< data_channel_set* > m_meshes;
	};

#endif
	// HACK : TEMPORARY - will go to it's own file, probably nmd_io
	void ndfm_dump_header( stream& stream_out, uint16 elements, shash64 name );
	void ndfm_dump_strings( stream& stream_out, const string_table& strings );
	void ndfm_dump_element( stream& stream_out, const data_channel_set& data, shash64 type );
	void ndfm_dump_animation( stream& stream_out, const mesh_nodes_data& nodes );
	void ndfm_dump_bones( stream& stream_out, const data_node_list& bones );


}

#endif // NV_FORMATS_NDFM_LOADER_HH
