// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_HANDLE_HH
#define NV_LUA_HANDLE_HH

#include <nv/common.hh>
#include <nv/stl/handle.hh>
#include <nv/stl/handle_manager.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
		//void register_handle( lua_State* L );

		template < typename T >
		struct handle_tag_table
		{

		};

		template <>
		struct handle_tag_table< void >
		{
			static const int REGISTRYINDEX = 1;
		};

		namespace detail
		{
			struct handle_struct
			{
				uint32 index;
				uint32 counter;
			};

			union handle_conversion
			{
				handle_struct h;
				double        d;
			};

			void push_handle_impl( lua_State* L, int pseudoindex, uint32 index );
			handle_struct to_handle_impl( lua_State* L, int i, uint32 dindex, uint32 dcounter );
			void register_handle_impl( lua_State* L, int pseudoindex, uint32 index, uint32 counter, bool empty );
			void unregister_handle_impl( lua_State* L, int pseudoindex, uint32 index );
		}

		template < typename H >
		void push_handle( lua_State* L, const H& handle )
		{
			typedef handle_operator<H> hop; 
			detail::push_handle_impl( L, handle_tag_table< typename H::tag_type >::REGISTRYINDEX, hop::get_index( handle ) );
		};

		template < typename H >
		H to_handle( lua_State* L, int index )
		{
			typedef handle_operator<H> hop; 
			detail::handle_struct h = detail::to_handle_impl( L, index, 0, 0 );
			return hop::create( h.index, h.counter );
		};

		template < typename H >
		H to_handle( lua_State* L, int index, const H& def )
		{
			typedef handle_operator<H> hop; 
			detail::handle_struct h = detail::to_handle_impl( L, index, hop::get_index( def ), hop::get_counter( def ) );
			return hop::create( h.index, h.counter );
		};


		template < 
			typename T, 
			unsigned IBITS,
			unsigned CBITS,
			typename TAG 
		>
		struct pass_traits< handle< T, IBITS, CBITS, TAG > >
		{
			typedef handle< T, IBITS, CBITS, TAG > value_type;
			static void push( lua_State *L, const value_type& p ) { push_handle< value_type >( L, p ); }
			static value_type to( lua_State *L, int index ) { return to_handle< value_type >( L, index ); }
			static value_type to( lua_State *L, int index, const value_type& def ) { return to_handle< value_type >( L, index, def ); }
		};

		template < typename H >
		void register_handle( lua_State *L, const H& handle, bool empty = true )
		{
			typedef handle_operator<H> hop; 
			detail::register_handle_impl( L, handle_tag_table< typename H::tag_type >::REGISTRYINDEX, hop::get_index( handle ), hop::get_counter( handle ), empty );
		}

		template < typename H >
		void unregister_handle( lua_State *L, const H& handle )
		{
			typedef handle_operator<H> hop; 
			detail::unregister_handle_impl( L, handle_tag_table< typename H::tag_type >::REGISTRYINDEX, hop::get_index( handle ) );
		}

	}

}

#endif // NV_LUA_GLM_HH
