// Copyright (C) 2014-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file vector.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief exception free vector class
 */

#ifndef NV_STL_VECTOR_HH
#define NV_STL_VECTOR_HH

#include <nv/common.hh>
#include <nv/stl/container/random_access.hh>
#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/growing_storage.hh>

namespace nv
{

	template< typename T >
	using growable_dynamic_storage = growing_storage< dynamic_storage< T > >;

	template< typename T, uint32 N >
	using growable_static_storage = growing_storage< static_storage< T, N > >;

	template< typename T, typename InitializePolicy = policy_initialize_standard >
	using vector = 
		random_access <
			growing_storage< dynamic_storage< T >, InitializePolicy > >;

}

#endif // NV_STL_VECTOR_HH
