// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/resource_system.hh"
#include "nv/stl/range.hh"
#include "nv/lua/lua_nova.hh"

void nv::lua_resource_manager_base::initialize( lua::state* a_lua_state )
{
	m_lua = a_lua_state;
	string128 storage_name = "register_" + get_resource_name();
	lua::register_storage( m_lua, get_storage_name(), storage_name );
}

bool nv::lua_resource_manager_base::load_resource( const string_view& id )
{
	lua::table_guard table( m_lua, lua::path( get_storage_name(), id ) );
	load_resource( table, id );
	return true;
}

void nv::lua_resource_manager_base::load_all( bool do_clear )
{
	if ( do_clear ) clear();
	lua::table_guard table( m_lua, get_storage_name() );
	uint32 count = table["__counter"].get_uint32();
	for ( auto i : range( count ) )
	{
		lua::table_guard sub_table( table, i + 1 );
		shash64 id = sub_table["id"].get_shash64();
		load_resource( sub_table, id );
	}
}

void nv::lua_resource_manager_base::preload_ids()
{
	m_id_hash.clear();
	lua::table_guard table( m_lua, get_storage_name() );
	uint32 count = table["__counter"].get_uint32();
	for ( auto i : range( count ) )
	{
		lua::table_guard sub_table( table, i + 1 );
		string64 id = sub_table["id"].get_string64();
		NV_ASSERT( m_id_hash.find( id ) == m_id_hash.end(), "HASH COLLISION" );
		m_id_hash[id] = id;
	}
}
