// Copyright (C) 2017-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lua/lua_proxy.hh"

#include "nv/lua/lua_raw.hh"
#include "nv/lua/lua_state.hh"

using namespace nv;
using namespace nv::lua;

nv::string64 nv::lua::stack_proxy::get_string64() const
{
	size_t l = 0;
	const char* str = nullptr;
	if ( lua_type( *m_state, m_index ) == LUA_TSTRING )
	{
		str = lua_tolstring( *m_state, m_index, &l );
	}
	return string64( str, static_cast<uint32>( l ) );
}

nv::string64 nv::lua::stack_proxy::to_string64()
{
	size_t l = 0;
	const char* str = nullptr;
	str = lua_tolstring( *m_state, m_index, &l );
	return string64( str, static_cast<uint32>( l ) );
}
