// Copyright (C) 2017-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_PROXY_HH
#define NV_LUA_PROXY_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>

namespace nv
{
	namespace lua
	{
		class state;

		class stack_proxy
		{
		public:
			stack_proxy( state* state, sint32 index ) : m_state( state ), m_index( index ) {}
			stack_proxy( const stack_proxy& ) = delete;
			stack_proxy& operator=( const stack_proxy& ) = delete;
			stack_proxy( stack_proxy&& ) = default;
			stack_proxy& operator=( stack_proxy&& ) = default;
			string64 get_string64() const;
			string64 to_string64();
			// TO FUCKING DO : non-copyable stringview
//			string_view get_string_view() const;
//			string_view to_string_view();
		protected:
			state* m_state;
			sint32 m_index;
		};

		class kv_proxy
		{
		public:
			kv_proxy( state* state ) : m_state( state ) {}
			kv_proxy( const kv_proxy& ) = delete;
			kv_proxy& operator=( const kv_proxy& ) = delete;
			kv_proxy( kv_proxy&& ) = default;
			kv_proxy& operator=( kv_proxy&& ) = default;
			const stack_proxy key() const { return stack_proxy( m_state, -2 ); }
			stack_proxy value() const { return stack_proxy( m_state, -1 ); }
		protected:
			state* m_state;
		};

	}

}

#endif // NV_LUA_PROXY_HH
