// Copyright (C) 2017-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lua/lua_iterator.hh"

#include "nv/lua/lua_raw.hh"
#include "nv/lua/lua_state.hh"

using namespace nv;
using namespace nv::lua;

nv::lua::iterator_provider_base::iterator_provider_base( state* parent, int index )
{
	m_parent = parent;
	m_index = nlua_absindex( *m_parent, index );
	m_level = lua_gettop( *m_parent );
	lua_pushnil( *m_parent );
}

nv::lua::iterator_provider_base::~iterator_provider_base()
{
	if ( m_parent )
		lua_settop( *m_parent, m_level );
}

void nv::lua::iterator_base::next()
{
	if ( !m_state ) return;
	lua_pop( *( m_state ), 1 );
	if ( lua_next( *( m_state ), m_index ) == 0 )
		m_state = nullptr;
}

nv::lua::iterator_base::iterator_base( state* state, sint32 index )
	: m_state( state ), m_index( index )
{
	if ( m_state )
		if ( lua_next( *( m_state ), m_index ) == 0 )
			m_state = nullptr;
}
