// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/shadow.hh"

using namespace nv;

void shadow_data::initialize( context* context, uint32 count, uint32 map_size, const render_pass& pass_base )
{
	m_map_size = map_size;
	m_maps = context->create_texture( TEXTURE_2D_ARRAY, ivec3( map_size, map_size, count ), DEPTH24, sampler( sampler::LINEAR, sampler::CLAMP_TO_EDGE ), nullptr );
	m_passes.resize( count );
	for ( uint32 i = 0; i < count; ++i )
	{
		framebuffer shadow_fbuffer = context->create_framebuffer();
		if ( m_color_maps )
			context->attach( shadow_fbuffer, OUTPUT_0, m_color_maps, i );
		context->attach( shadow_fbuffer, m_maps, i );
		context->check( FRAMEBUFFER );
		context->bind( framebuffer() );

		m_passes[i] = pass_base;
		m_passes[i].output[0] = OUTPUT_NONE;
		m_passes[i].output_count = 1;
		m_passes[i].fbuffer = shadow_fbuffer;
	}
}

void nv::shadow_data::initialize( context* context, uint32 count, uint32 map_size, const render_pass& pass_base, const render_pass& color_base )
{
	m_color_maps = context->create_texture( TEXTURE_2D_ARRAY, ivec3( map_size, map_size, count ), RGBA16F, sampler( sampler::LINEAR, sampler::CLAMP_TO_EDGE ), nullptr );

	initialize( context, count, map_size, pass_base );

	m_color_passes.resize( count );
	for ( uint32 i = 0; i < count; ++i )
	{
		m_color_passes[i] = color_base;
		m_color_passes[i].output[0] = OUTPUT_0;
		m_color_passes[i].output_count = 1;
		m_color_passes[i].fbuffer = m_passes[i].fbuffer;
	}

}
