// Copyright (C) 2016-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file bullet_helper.hh
 * @author Kornel Kisielewicz
 * @brief bullet helper functions
 */

#ifndef NV_BULLET_HELPER_HH
#define NV_BULLET_HELPER_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/core/transform.hh>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btTransform.h>

namespace nv
{
	btVector3 n2b( vec3 v )
	{
		return btVector3( v.x, v.y, v.z );
	}

	vec3 b2n( const btVector3& v )
	{
		return vec3( v.getX(), v.getY(), v.getZ() );
	}

	btQuaternion n2b( quat v )
	{
		return btQuaternion( v.x, v.y, v.z, v.w );
	}

	quat b2n( const btQuaternion& v )
	{
		return quat( v.getW(), v.getX(), v.getY(), v.getZ() );
	}

	btTransform n2b( transform tr )
	{
		return btTransform( n2b( tr.get_orientation() ), n2b( tr.get_position() ) );
	}

	transform b2n( const btTransform& v )
	{
		return transform( b2n( v.getOrigin() ), b2n( v.getRotation() ) );
	}
}

#endif // NV_BULLET_HELPER_HH
