// Copyright (C) 2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file bullet_world.hh
 * @author Kornel Kisielewicz
 * @brief bullet_world
 */

#ifndef NV_BULLET_WORLD_HH
#define NV_BULLET_WORLD_HH

#include <nv/common.hh>
#include <nv/interface/physics_world.hh>

namespace nv
{
	class bullet_world : public physics_world
	{
	public:
		bullet_world();
		virtual int step_simulation( float dtime, int max_sub_steps = 1, float fixed_time_step = 1.0f / 60.0f );
		virtual void set_gravity( const vec3& gravity );
		virtual collision_shape create_sphere( float radius );
		virtual collision_shape create_capsule( float radius, float height );
		virtual collision_shape create_cylinder( const vec3& half_extents );
		virtual collision_shape create_box( const vec3& half_extens );
		virtual collision_shape create_static_plane( const vec3& norm, float cst );
		virtual collision_shape create_mesh( array_view< vec3 > vtx, array_view< uint32 > idx );
		virtual rigid_body create_rigid_body( float mass, const transform& tr, collision_shape shape, const vec3& com_offset = vec3() );
		virtual constraint create_hinge_constraint( rigid_body a, const transform& ta, rigid_body b, const transform& tb, const vec2& low_high, const vec3& params = vec3( 0.9f, 0.3f, 1.0f ) );
		virtual constraint create_cone_twist_constraint( rigid_body a, const transform& ta, rigid_body b, const transform& tb, const vec3& sst, const vec3& params = vec3( 1.0f, 0.3f, 1.0f ) );
		virtual void add_rigid_body( rigid_body body );
		virtual void remove_rigid_body( rigid_body body );
		virtual void add_constraint( constraint cons );
		virtual void set_rigid_body_damping( rigid_body body, float linear, float angular );
		virtual void set_rigid_body_deactivation_time( rigid_body body, float time );
		virtual void set_rigid_body_activation_state( rigid_body body, activation_state state );
		virtual void set_rigid_body_sleeping_thresholds( rigid_body body, float linear, float angular );
		virtual void set_rigid_body_linear_velocity( rigid_body body, const vec3& velocity );
		virtual void set_rigid_body_ccd( rigid_body body, float radius, float threshold );

		virtual nv::transform get_world_transform( rigid_body body );
		virtual void set_world_transform( rigid_body body, const nv::transform& tr );
		virtual int get_collision_flags( rigid_body body );
		virtual void set_collision_flags( rigid_body body, int flags );

		virtual bool ray_test( const vec3& from, const vec3& to, vec3& hpos, vec3& hnorm, bool static_only = false );
		virtual void release( collision_shape );
		virtual void release( rigid_body );
		virtual void release( constraint );
	protected:
		void* world;
	};

}

#endif // NV_BULLET_WORLD_HH
