// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/default_resource_manager.hh"

using namespace nv;

default_resource_manager::default_resource_manager( context* context, bool clear_material_paths )
{
	m_images = register_resource_handler< image_data >( new image_manager );
	m_meshes = register_resource_handler< data_channel_set >( new mesh_manager );
	m_binds = register_resource_handler< animator_bind_data >( new animator_bind_manager );
	m_animators = register_resource_handler< animator_data >( new animator_manager );
	m_materials = register_resource_handler< material >( new material_manager( clear_material_paths ) );
	m_programs = register_resource_handler< program >( new program_manager( context ) );
	m_gpu_meshes = register_resource_handler< gpu_mesh >( new gpu_mesh_manager( context, m_meshes ) );
	m_mesh_datas = register_resource_handler< mesh_data >( new mesh_data_manager( m_meshes ) );
	m_gpu_materials = register_resource_handler< gpu_material >( new gpu_material_manager( context, m_materials, m_images ) );
	m_models = register_resource_handler< model >( new model_manager( this, m_binds, m_mesh_datas ) );
	m_particles = register_resource_handler< particle_system_data >( new particle_manager );
	m_ragdolls = register_resource_handler< ragdoll_data >( new ragdoll_manager( m_models ) );
}

void default_resource_manager::initialize( lua::state* lua, physics_world* world )
{
	m_lua = lua;

	int below_already_registered;
	m_lua->register_enum( "RND_LINEAR",     static_cast<int>( random_dist::LINEAR ) );
	m_lua->register_enum( "RND_GAUSSIAN",   static_cast<int>( random_dist::GAUSSIAN ) );
	m_lua->register_enum( "RND_RGAUSSIAN",  static_cast<int>( random_dist::RGAUSSIAN ) );
	m_lua->register_enum( "RND_STEP_1",     static_cast<int>( random_dist::STEP_1 ) );
	m_lua->register_enum( "RND_STEP_2",     static_cast<int>( random_dist::STEP_2 ) );
	m_lua->register_enum( "RND_STEP_3",     static_cast<int>( random_dist::STEP_3 ) );
	m_lua->register_enum( "RND_STEP_4",     static_cast<int>( random_dist::STEP_4 ) );
	m_lua->register_enum( "RND_LINEAR",     static_cast<int>( random_dist::LINEAR ) );
	m_lua->register_enum( "RND_MGAUSSIAN",  static_cast<int>( random_dist::MGAUSSIAN ) );
	m_lua->register_enum( "RND_MRGAUSSIAN", static_cast<int>( random_dist::MRGAUSSIAN ) );
	m_lua->register_enum( "RND_MSTEP_1",    static_cast<int>( random_dist::MSTEP_1 ) );
	m_lua->register_enum( "RND_MSTEP_2",    static_cast<int>( random_dist::MSTEP_2 ) );
	m_lua->register_enum( "RND_MSTEP_3",    static_cast<int>( random_dist::MSTEP_3 ) );
	m_lua->register_enum( "RND_MSTEP_4",    static_cast<int>( random_dist::MSTEP_4 ) );
	
	m_lua->register_enum( "INT_NONE",       static_cast<int>( interpolation::NONE ) );
	m_lua->register_enum( "INT_LINEAR",     static_cast<int>( interpolation::LINEAR ) );
	m_lua->register_enum( "INT_NORMALIZED", static_cast<int>( interpolation::NORMALIZED ) );
	m_lua->register_enum( "INT_SPHERICAL",  static_cast<int>( interpolation::SPHERICAL ) );
	m_lua->register_enum( "INT_QUADRATIC",  static_cast<int>( interpolation::QUADRATIC ) );
	m_lua->register_enum( "INT_SQUADRATIC", static_cast<int>( interpolation::SQUADRATIC ) );

	m_lua->register_enum( "EASING_BACK",    static_cast<int>( easing_type::BACK ) );
	m_lua->register_enum( "EASING_BOUNCE",  static_cast<int>( easing_type::BOUNCE ) );
	m_lua->register_enum( "EASING_CIRC",    static_cast<int>( easing_type::CIRC ) );
	m_lua->register_enum( "EASING_CUBIC",   static_cast<int>( easing_type::CUBIC ) );
	m_lua->register_enum( "EASING_ELASTIC", static_cast<int>( easing_type::ELASTIC ) );
	m_lua->register_enum( "EASING_EXPO",    static_cast<int>( easing_type::EXPO ) );
	m_lua->register_enum( "EASING_LINEAR",  static_cast<int>( easing_type::LINEAR ) );
	m_lua->register_enum( "EASING_QUAD",    static_cast<int>( easing_type::QUAD ) );
	m_lua->register_enum( "EASING_QUART",   static_cast<int>( easing_type::QUART ) );
	m_lua->register_enum( "EASING_QUINT",   static_cast<int>( easing_type::QUINT ) );
	m_lua->register_enum( "EASING_SINE",    static_cast<int>( easing_type::SINE ) );

	m_lua->register_enum( "CHOICE_ALL", static_cast<int>( model_node_choice::ALL ) );
	m_lua->register_enum( "CHOICE_WEIGHTED", static_cast<int>( model_node_choice::WEIGHTED ) );
	m_lua->register_enum( "CHOICE_PATTERN_CHECKER", static_cast<int>( model_node_choice::PATTERN_CHECKER ) );

	m_materials->initialize( lua );
	m_programs->initialize( lua );
	m_animators->initialize( lua );
	m_models->initialize( lua );
	m_particles->initialize( lua );
	m_ragdolls->initialize( lua );
	m_ragdolls->initialize( world );
}

void default_resource_manager::reload_data()
{
	m_materials->clear();
	m_materials->load_all();
	//	m_models->load_all();
	//	m_programs->load_all();
}

void nv::default_resource_manager::add_path( const string_view& path )
{
	m_images->add_base_path( path );
	m_mesh_datas->add_base_path( path );
	m_programs->add_base_path( path );
	m_animators->add_base_path( path );
}
