#include <nv/lib/lua.hh>
#include <nv/lua/lua_raw.hh>
#include <nv/logger.hh>
#include <string>
#include <iostream>

int main(int, char* [])
{
	nv::logger log(nv::LOG_TRACE);
	log.add_sink( new nv::log_file_sink("log.txt"), nv::LOG_TRACE );
	log.add_sink( new nv::log_console_sink(), nv::LOG_TRACE );
	nv::load_lua_library();
		
	NV_LOG( nv::LOG_NOTICE, "Logging started" );

	// create new Lua state
	lua_State *lua_state;
	lua_state = luaL_newstate();

	// load Lua libraries
	static const luaL_Reg lualibs[] =
	{
		{ "base", luaopen_base },
		{ NULL, NULL}
	};

	const luaL_Reg *lib = lualibs;
	for(; lib->func != NULL; lib++)
	{
		lib->func(lua_state);
		lua_settop(lua_state, 0);
	}

	// run the Lua script
	luaL_dofile(lua_state, "init.lua");

	while (true)
	{
		std::string input;
		int stack = lua_gettop( lua_state );
		std::cout << "LUA (" << stack << ") > ";
		std::getline( std::cin, input );
		if (input == "quit")
		{
			break;
		}

		if (input.find("=", 0) == std::string::npos && 
			input.find("if", 0) == std::string::npos && 
			input.find("return", 0) == std::string::npos)
		{
			input = "return " + input;
		}

		std::cout << "> " << input << std::endl;

		int code = luaL_loadstring( lua_state, input.c_str() );
		if (code == 0) code = lua_pcall( lua_state, 0, LUA_MULTRET, 0);
		if (code != 0)
		{
			std::string error = lua_tostring( lua_state, -1 );
			std::cout << "ERROR : " << error << std::endl;
			lua_settop( lua_state, stack );
			continue;
		}

		if (lua_gettop( lua_state ) > stack)
		{
			for ( int i = stack+1; i <= lua_gettop( lua_state ); ++i )
			{
				std::cout << nlua_typecontent( lua_state, i ) << std::endl;
			}
		}
		lua_settop( lua_state, stack );
	}


	// close the Lua state
	lua_close(lua_state);
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );

	return 0;
}

