// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_ENGINE_RENDER_PASS_HH
#define NV_ENGINE_RENDER_PASS_HH

#include <nv/common.hh>
#include <nv/stl/flags.hh>
#include <nv/core/resource.hh>
#include <nv/interface/context.hh>
#include <nv/interface/device.hh>

namespace nv
{

	struct render_pass
	{
		render_state        rstate;
		clear_state         cstate;
		framebuffer         fbuffer;
		output_slot         output[8];
		uint32              output_count;
		flags< 32 >         exclude;
		flags< 32 >         any;
		resource< program > programs[4];
		texture             binds[16];
	};

}



#endif // NV_ENGINE_RENDER_PASS_HH
