// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/model_manager.hh"

#include "nv/lua/lua_math.hh"

using namespace nv;

bool nv::model_manager::load_resource( lua::table_guard& table, shash64 id )
{
	model* gm = new model;
	gm->attach = table.get_string_hash_64( "attach" );
	gm->root = transform( table.get<vec3>( "position", vec3() ) );

	resource< mesh_data > def_data;
	if ( table.is_string( "path" ) )
		def_data = m_rm->get< mesh_data >( table.get_string128( "path" ) );

	if ( table.has_field( "animator" ) )
	{
		gm->animator = m_rm->get< animator_data >( table.get_string( "animator" ) );
		pose_data_set* poses = gm->animator.lock()->poses;
		if ( !def_data || !def_data.lock()->node_data )
			gm->bind_data = m_animator_binds->add( id, new animator_bind_data( poses->get_tree(), poses->get_tree() ) );
		else
			gm->bind_data = m_animator_binds->add( id, new animator_bind_data( poses->get_tree(), *def_data.lock()->node_data ) );
	}

	if ( table.is_table( "model" ) )
	{
		lua::table_guard model_table( table, "model" );
		read_model_node( model_table, gm, def_data );
	}

	add( id, gm );
	return true;
}



void nv::model_manager::read_model_node( lua::table_guard& table, model_node* node, resource< mesh_data > def_data )
{
	resource< data_channel_set > cmesh;
	resource< material >         cmaterial;
	sint16 attach_id = -1;

	if ( table.is_string( "material" ) )
		cmaterial = m_rm->get< material >( table.get_string128( "material" ) );

	if ( table.has_field( "path" ) )
	{
		nv::string128 cpath( table.get_string128( "path" ) );
		nv::data_node_info info;
		cmesh = m_mesh_datas->get_path( cpath, def_data, &info );
		attach_id = info.parent_id;
	}

	if ( table.has_field( "attach" ) )
	{
		if ( table.is_number( "attach" ) )
		{
			attach_id = table.get_integer( "attach", -1 );
			//				parent_id = 0;
		}
		else if ( auto m = def_data.lock() )
		{
			auto it = m->node_names.find( table.get_string_hash_64( "attach" ) );
			if ( it != m->node_names.end() )
				attach_id = it->second + 1;
			int error; int hack;
		}
	}

	node->force = table.get_boolean( "force", false );
	node->chance = table.get_float( "chance", 1.0f );
	node->random_rotate_y = table.get_boolean( "random_rotate", false );

	node->mesh = cmesh;
	node->attach_id = attach_id;
	node->material = cmaterial;

	for ( uint32 i = 1; i <= table.get_size(); ++i )
	{
		lua::table_guard child_table( table, i );
		model_node* child = new model_node;
		node->children.push_back( child );
		read_model_node( child_table, child, def_data );
	}
}

