// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/image_manager.hh"

#include "nv/image/png_loader.hh"
#include "nv/io/c_file_system.hh"

using namespace nv;

void nv::image_manager::add_base_path( const string_view& path )
{
	m_paths.emplace_back( path );
}

bool image_manager::load_resource( const string_view& filename )
{
	png_loader loader;
	c_file_system fs;
	image_data* result = nullptr;
	if ( fs.exists( filename ) )
	{
		stream* file = fs.open( filename );
		result = loader.load( *file );
		delete file;
	}
	else if ( m_paths.size() > 0 )
	{
		for ( const auto& path : m_paths )
		{
			string128 fpath = path;
			fpath.append( filename );
			if ( fs.exists( fpath ) )
			{
				stream* file = fs.open( fpath );
				result = loader.load( *file );
				delete file;
				break;
			}
		}
	}
	if ( result ) 
		add( filename, result );
	return result != nullptr;
}

