// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file image_manager.hh
* @author Kornel Kisielewicz
* @brief image_manager
*/

#ifndef NV_ENGINE_IMAGE_MANAGER_HH
#define NV_ENGINE_IMAGE_MANAGER_HH

#include <nv/common.hh>
#include <nv/core/resource.hh>
#include <nv/interface/image_data.hh>
#include <nv/engine/resource_system.hh>

namespace nv
{

	NV_RTTI_DECLARE_NAME( image_data, "image_data" )

	class image_manager : public manual_resource_manager< image_data >
	{
	public:
		image_manager() {}
		void add_base_path( const string_view& path );
	protected:
		virtual bool load_resource( const string_view& id );
		vector< string128 > m_paths;
	};



}

#endif // NV_ENGINE_IMAGE_MANAGER_HH
