// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/material_manager.hh"

#include "nv/io/c_file_system.hh"
#include "nv/image/png_loader.hh"

using namespace nv;


nv::gpu_material_manager::gpu_material_manager( context* context, material_manager* matmgr, image_manager* imgmgr )
	: m_context( context )
	, m_material_manager( matmgr )
	, m_image_manager( imgmgr )
{
	uint8 data[2 * 2 * 3];
	nv::raw_fill_n( data, 2 * 2 * 3, 0 );
	m_default = m_context->get_device()->create_texture( ivec2(2,2), nv::image_format( nv::RGB ), nv::sampler(), data );
}

bool gpu_material_manager::load_resource( const string_view& id )
{
	if ( auto mat = m_material_manager->get( id ).lock() )
	{
		gpu_material* result = new gpu_material;
		sampler smp( sampler::LINEAR, sampler::REPEAT );
		for ( uint32 i = 0; i < size( mat->paths ); ++i )
			if ( !mat->paths[i].empty() )
			{
				if ( auto data = m_image_manager->get( mat->paths[i] ).lock() )
				{
					result->textures[i] = m_context->get_device()->create_texture( &*data, smp );
				}
			}

		// HACK
 		for ( uint32 i = 0; i < 5; ++i )
 			if ( result->textures[i].is_nil() )
 				result->textures[i] = m_default;
			
		add( id, result );
		return true;
	}
	return false;
}

void gpu_material_manager::release( gpu_material* m )
{
	for ( const texture& t : m->textures )
	{
		m_context->get_device()->release( t );
	}
}

bool material_manager::load_resource( nv::lua::table_guard& table, nv::shash64 id )
{
	material* m = new material;
	m->paths[ TEX_DIFFUSE ]  = table.get_string128( "diffuse" );
	m->paths[ TEX_SPECULAR ] = table.get_string128( "specular" );
	m->paths[ TEX_NORMAL ]   = table.get_string128( "normal" );
	m->paths[ TEX_EMISSIVE ] = table.get_string128( "emissive" );
	m->paths[ TEX_GLOSS ]    = table.get_string128( "gloss" );
	add( id, m );
	return true;
}
