// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/core/ascii_printer.hh"

using namespace nv;

ascii_printer::ascii_printer( terminal * term )
	: m_terminal( term )
{
	
}

void ascii_printer::print( const string_view& text, const position& p, uint32 color )
{
	position coord( p );
	for ( char c : text )
	{
		m_terminal->print( coord, color, static_cast<unsigned char>( c ) );
		++coord.x;
		if ( coord.x >= m_terminal->get_size().x ) break;
	}
}

void nv::ascii_printer::frame( const nv::rectangle& area, const nv::string_view& border_chars, uint32 color )
{
	if ( border_chars.length() < 8 )
	{
		m_terminal->clear( area );
		return;
	}
	m_terminal->clear( area.shrinked( 1 ) );
	for ( int x = 0; x < area.get_width(); ++x )
	{
		m_terminal->print( position( area.ul.x + x, area.ul.y ), color, border_chars[0] );
		m_terminal->print( position( area.ul.x + x, area.lr.y ), color, border_chars[1] );
	}

	for ( int y = 0; y < area.get_height(); ++y )
	{
		m_terminal->print( position( area.ul.x, area.ul.y + y ), color, border_chars[2] );
		m_terminal->print( position( area.lr.x, area.ul.y + y ), color, border_chars[3] );
	}

	m_terminal->print( area.ul, color, border_chars[4] );
	m_terminal->print( area.ur(), color, border_chars[5] );
	m_terminal->print( area.ll(), color, border_chars[6] );
	m_terminal->print( area.lr, color, border_chars[7] );
}
