// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/mesh_manager.hh"

using namespace nv;

resource< gpu_mesh > gpu_mesh_manager::load_resource( resource< data_channel_set > mesh )
{
	resource< gpu_mesh > result = get( mesh.id().value() );
	if ( result ) return result;
	if ( auto lmesh = mesh.lock() )
	{
		gpu_mesh* gm = new gpu_mesh;
		gm->va = m_context->create_vertex_array( &*lmesh, STATIC_DRAW );
		gm->count = lmesh->get_channel_size( slot::INDEX );
		gm->shader = lmesh->get_channel( slot::BONEINDEX ) != nullptr ? BONE : NORMAL;
		return add( mesh.id(), gm );
	}
	return resource< gpu_mesh >();
}

bool nv::gpu_mesh_manager::load_resource( const string_view& id )
{
	if ( auto lmesh = m_mesh_manager->get( id ).lock() )
	{
		gpu_mesh* gm = new gpu_mesh;
		gm->va = m_context->create_vertex_array( &*lmesh, STATIC_DRAW );
		gm->count = lmesh->get_channel_size( slot::INDEX );
		gm->shader = lmesh->get_channel( slot::BONEINDEX ) != nullptr ? BONE : NORMAL;
		add( id, gm );
		return true;
	}
	return false;
}

void gpu_mesh_manager::release( gpu_mesh* m )
{
	m_context->release( m->va );
}
