// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_GFX_SKELETAL_MESH_HH
#define NV_GFX_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/stl/array.hh>
#include <nv/gfx/skeleton_instance.hh>

namespace nv
{
	
 	class skeletal_animation_entry : public animation_entry
 	{
	public:
		skeletal_animation_entry( shash64 name, const mesh_nodes_data* anim, uint32 fps, uint32 time_start, uint32 time_end, bool a_looping )
			: animation_entry( name, a_looping, fps, time_start, time_end )
			, m_temp_anim( anim )
		{
		}
		const skeleton_binding& get_binding() const { return m_data; }
		void prepare( const mesh_nodes_data* bones );
		void update_skeleton( skeleton_instance& tr, uint32 a_ms_time ) const;
		
	protected:
		const mesh_nodes_data* m_temp_anim;
		skeleton_binding m_data;
 	};

	class skeletal_mesh : public animated_mesh
	{
	public:
		skeletal_mesh( context* a_context, const data_channel_set* a_mesh, const mesh_nodes_data* a_bone_data );
		virtual vertex_array get_vertex_array() const { return m_va; }
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry& a_anim )
		{
			update_animation( a_anim, 0 );
		}
		virtual void update_program( program a_program );
		virtual void update_animation( animation_entry& a_anim, uint32 a_anim_time );
		virtual transform get_node_transform( uint32 node_id ) const;
		virtual mat4 get_node_matrix( uint32 node_id ) const;
		virtual sint16 get_parent_id() const { return m_parent_id; }
		virtual uint32 get_node_count() const { return m_skeleton.size(); }
		skeleton_instance& get_skeleton() { return m_skeleton; }
		const mesh_nodes_data* get_bone_data() { return m_bone_data; }
		context* get_context() { return m_context;  }
		~skeletal_mesh()
		{
			m_context->release( m_va );
		}
	protected:
		skeleton_instance m_skeleton;
		vertex_array m_va;
		uint32       m_index_count;
		context*     m_context;
		const mesh_nodes_data* m_bone_data;
		sint16 m_parent_id;
	};

} // namespace nv

#endif // NV_GFX_SKELETAL_MESH_HH
