// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_GFX_SKELETON_INSTANCE_HH
#define NV_GFX_SKELETON_INSTANCE_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/mesh_data.hh>

namespace nv
{

	class skeleton_instance
	{
	public:
		explicit skeleton_instance( const mesh_nodes_data* data )
			: m_data( data )
			, m_indices( nullptr )
			, m_offsets( nullptr )
		{
		}
		void prepare( const mesh_nodes_data* data );
		void animate( mat4* data, float frame ) const;
		~skeleton_instance()
		{
			delete[] m_indices;
			delete[] m_offsets;
		}
	protected:
		void animate_rec( mat4* data, float frame, uint32 id, const mat4& parent ) const;
		void animate_flat( mat4* data, float frame ) const;

		const mesh_nodes_data* m_data;
		sint16*                m_indices;
		mat4*                  m_offsets;
		data_descriptor        m_key;
	};

}

#endif // NV_GFX_SKELETON_INSTANCE_HH
