// Copyright (C) 2011-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/gfx/skeletal_mesh.hh"

#include "nv/interface/context.hh"
#include "nv/interface/device.hh"
#include "nv/stl/unordered_map.hh"

#include "nv/core/logging.hh"

void nv::skeletal_animation_entry::update_skeleton( mat4* data, uint32 a_ms_time ) const
{
	float  fframe   = ( a_ms_time * 0.001f ) * m_fps;
	uint32 frame    = uint32( math::floor( fframe ) );
	float  reminder = fframe - static_cast<float>( frame );
	uint32 duration = get_frame_count();
	if ( duration == 0 )
	{
		frame  = get_start_frame();
		fframe = static_cast<float>( frame );
	}
	else if ( frame >= duration )
	{
		if ( is_looping() )
		{
			frame  = frame % duration;
			fframe = static_cast<float>( frame ) + reminder;
		}
		else
		{
			frame  = get_end_frame();
			fframe = static_cast<float>( frame );
		}
	}

	m_data.animate( data, fframe );
}

void nv::skeletal_animation_entry::prepare( const mesh_nodes_data* bones )
{
	m_data.prepare( bones );
}

nv::skeletal_mesh::skeletal_mesh( context* a_context, const data_channel_set* a_mesh, const mesh_nodes_data* a_bone_data )
	: m_context( a_context ), m_bone_data( a_bone_data ), m_index_count( 0 ), m_transform( nullptr ), m_parent_id(-1)
{
	if ( a_mesh )
	{
		m_va = a_context->create_vertex_array( a_mesh, nv::STATIC_DRAW );
		m_index_count = a_mesh->get_channel_size( slot::INDEX );
		m_parent_id = a_mesh->get_parent_id();
	}
	if ( m_bone_data )
	{
		m_transform = new mat4[ m_bone_data->size() ];
	}
}

void nv::skeletal_mesh::update_animation( animation_entry* a_anim, uint32 a_anim_time )
{
	if ( m_bone_data && a_anim )
	{
		skeletal_animation_entry * anim = static_cast<skeletal_animation_entry*>( a_anim );
		anim->prepare( m_bone_data );
		anim->update_skeleton( m_transform, a_anim_time );
	}
}

void nv::skeletal_mesh::update( program a_program )
{
	if ( m_bone_data )
		m_context->get_device()->set_opt_uniform_array( a_program, "nv_m_bones", m_transform, m_bone_data->size() );
}

nv::transform nv::skeletal_mesh::get_node_transform( uint32 node_id ) const
{
	return transform( m_transform[ node_id ] );
}

nv::mat4 nv::skeletal_mesh::get_node_matrix( uint32 node_id ) const
{
	return m_transform[ node_id ];
}
