// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_device.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Device class
 */

#ifndef NV_GL_DEVICE_HH
#define NV_GL_DEVICE_HH

#include <nv/interface/device.hh>

namespace nv
{
	class gl_device : public device
	{
	public:
		gl_device();
		virtual window* create_window( uint16 width, uint16 height );
		virtual program* create_program( const string& vs_source, const string& fs_source );
		virtual vertex_buffer* create_vertex_buffer( buffer_hint hint, int size, void* source = nullptr );
		virtual index_buffer* create_index_buffer( buffer_hint hint, int size, void* source = nullptr );
		virtual vertex_array* create_vertex_array();
		virtual texture2d* create_texture2d( ivec2 size, texture2d::format aformat, texture2d::datatype adatatype, texture2d_sampler sampler, void* data = nullptr );
		virtual ~gl_device();
	private:
		const void* m_info;
	};

} // namespace nv


#endif // NV_GL_DEVICE_HH
