// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
//
// TODO : get rid of per-cell virtual calls

#ifndef NV_ROGUE_FOV_HH
#define NV_ROGUE_FOV_HH

#include <nv/common.hh>
#include <nv/core/position.hh>

namespace nv
{

	namespace rogue
	{
		class fov_interface
		{
		public:
			virtual bool is_transparent( const position& ) const = 0;
			virtual void set_visible( const position&, bool ) = 0;
		};

		class fov_algorithm
		{
		public:
			virtual void initialize( fov_interface*, const dimension& size ) = 0;
			virtual void run( const position& p, uint16 radius ) = 0;
			virtual ~fov_algorithm() {}
		};

	}

}

#endif // NV_ROGUE_FOV_HH
