// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gui_element.hh
 * @author Kornel Kisielewicz
 * @brief GUI Element
 */

#ifndef NV_GUI_ELEMENT_HH
#define NV_GUI_ELEMENT_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/core/io_event.hh>
#include <nv/stl/string.hh>
#include <nv/gui/gui_common.hh>

namespace nv
{
	namespace gui
	{

		class element
		{
		public:
			/// List type
			// TODO: change to small_vector once implemented!
			typedef vector< handle > child_list;
			shash64 m_id;              ///< id type of the object
			handle    m_parent;          ///< pointer to parent
			flags     m_flags;
			child_list m_children;        ///< children objects
			size_t    m_child_count;     ///< number of children
			shash64    m_class; ///< Class name.
			string_buffer m_text; ///< Displayed label or text.
			rectangle m_relative; ///< Position relative to parent.
			rectangle m_absolute; ///< Position relative to window/screen.
			render_data* m_render_data; ///<   -?-
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
