// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file texture2d.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Texture2D class
 */

#ifndef NV_TEXTURE2D_HH
#define NV_TEXTURE2D_HH

#include <nv/common.hh>
#include <nv/types.hh>

namespace nv
{

	struct texture2d_sampler
	{
		enum filter
		{
			LINEAR,
			NEAREST,
			NEAREST_MIPMAP_NEAREST,
			LINEAR_MIPMAP_NEAREST,
			NEAREST_MIPMAP_LINEAR,
			LINEAR_MIPMAP_LINEAR
		};
		enum wrap
		{
			CLAMP_TO_EDGE,
			CLAMP_TO_BORDER, 
			MIRRORED_REPEAT, 
			REPEAT
		};

		filter filter_min;
		filter filter_max;
		wrap wrap_s;
		wrap wrap_t;

		texture2d_sampler( filter min, filter max, wrap s, wrap t )
			: filter_min( min ), filter_max( max ), wrap_s( s ), wrap_t( t ) {}
		texture2d_sampler( filter f, wrap w )
			: filter_min( f ), filter_max( f ), wrap_s( w ), wrap_t( w ) {}

	};


	class texture2d
	{
	public:
		enum format
		{
			RGB,
			RGBA
		};

		enum datatype
		{
			UINT,
			UBYTE,
			FLOAT
		};
		texture2d( ivec2 size, format aformat, datatype adatatype, texture2d_sampler asampler ) : 
			m_size( size ), m_format( aformat ), m_datatype( adatatype ), m_sampler( asampler ) {}
		virtual void assign( void* data ) = 0;
		virtual void bind( int slot = 0 ) = 0;
		virtual void unbind() = 0;
		virtual bool is_valid() const = 0;
		const ivec2& get_size() const { return m_size; }
		int get_width() const { return m_size.x; }
		int get_height() const { return m_size.y; }
		format get_format() const { return m_format; }
		datatype get_datatype() const { return m_datatype; }
		const texture2d_sampler& get_sampler() const { return m_sampler; }
	protected:
		ivec2             m_size;
		format            m_format;
		datatype          m_datatype;
		texture2d_sampler m_sampler;
	};

} // namespace nv

#endif // NV_TEXTURE2D_HH
