// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_STL_STRING_SHORT_STRING_HH
#define NV_STL_STRING_SHORT_STRING_HH

#include <nv/stl/string/common.hh>
#include <nv/stl/string/string_base.hh>
#include <nv/stl/container/random_access.hh>
#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/growing_storage.hh>

namespace nv
{
	template < typename Storage >
	class string_buffer_ops : Storage
	{

	};

	template < typename T, size_t N >
	using short_string = 
		string_buffer_ops< 
			random_access <
				string_base< 
					growing_storage<
						static_storage< T, N > > > > >;

	template < typename T >
	using buffer_string = 
		string_buffer_ops< 
			random_access <
				string_base< 
					growing_storage< 
						dynamic_storage< T > > > > >;


}

#endif // NV_STL_STRING_SHORT_STRING_HH
