// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lua/lua_function.hh"

#include "nv/core/logging.hh"
#include "nv/lua/lua_raw.hh"

using namespace nv;

#define NV_LUA_ABORT( func, ... ) \
	NV_LOG_CRITICAL( "lua::" func " : ", __VA_ARGS__ ) \
	NV_ABORT( "lua::" func " : critical error!" )

lua::function_base::function_base( lua_State* a_L, const path& a_path, bool a_global /*= true*/ ) : L(a_L)
{
	if ( !a_path.resolve( L, a_global ) )
	{
		lua_pop( L, 1 );
		NV_LUA_ABORT( "function_base::function_base", "not a valid path - ", a_path.to_string().c_str() );
	}

	if ( !lua_isfunction( L, -1 ) ) 
	{
		lua_pop( L, 1 );
		NV_LUA_ABORT( "function_base::function_base", "not a valid function - ", a_path.to_string().c_str() );
	}
	m_ref = luaL_ref( L, LUA_REGISTRYINDEX );
}

lua::function_base::function_base( const function_base& func ) : L(func.L)
{
	lua_rawgeti( L, LUA_REGISTRYINDEX, func.m_ref );
	m_ref = luaL_ref( L, LUA_REGISTRYINDEX );
}

lua::function_base::~function_base()
{
	luaL_unref( L, LUA_REGISTRYINDEX, m_ref );
}

lua::function_base& lua::function_base::operator=(const function_base& func)
{
	if ( this != &func ) 
	{
		L = func.L;
		lua_rawgeti( L, LUA_REGISTRYINDEX, func.m_ref );
		m_ref = luaL_ref( L, LUA_REGISTRYINDEX );
	}
	return *this;
}

void lua::function_base::retrieve()
{
	lua_rawgeti( L, LUA_REGISTRYINDEX, m_ref );
}

void lua::function_base::call( int args, int results )
{
	int status = lua_pcall( L, args, results, 0 );
	if ( status != 0 )
	{
		std::string error = lua_tostring( L, -1 );
		lua_pop( L, 1 );
		NV_LUA_ABORT( "function_base::call", "call failed - ", error.c_str() );
	}
}

