// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_STL_STRING_COMMON_HH
#define NV_STL_STRING_COMMON_HH

#include <nv/common.hh>
#include <nv/stl/type_traits/primary.hh>
#include <nv/stl/type_traits/properties.hh>

namespace nv
{

	template < typename Storage > class string_base;
	class string_view;

	namespace detail
	{

		template < typename T, typename Enable = void >
		struct is_string_base_impl : false_type {};
		template < typename T >
		struct is_string_base_impl < T,
			typename enable_if<
			is_base_of< string_base< typename T::storage_type >, T >::value,
			void >::type > : true_type{};
	}


	// Stronger version
	//	template < typename T >
	//	struct is_string_base : is_template_base_of< T, string_base > {};
	template < typename T >
	struct is_string_base : detail::is_string_base_impl< T > {};

}

#endif // NV_STL_STRING_COMMON_HH
