// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file md5_loader.hh
 * @author Kornel Kisielewicz
 * @brief md5 loader
 */

#ifndef NV_FORMATS_MD5_LOADER_HH
#define NV_FORMATS_MD5_LOADER_HH

#include <nv/common.hh>
#include <nv/stl/array.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{

	struct md5_vtx_pnt
	{
		vec3 position;
		vec3 normal;
		vec3 tangent;
	};

	struct md5_key_t
	{
		transform tform;
	};

	struct md5_vtx_t
	{
		vec2 texcoord;
	};

	struct md5_vtx_pntiw
	{
		vec3  position;
		vec3  normal;
		vec3  tangent;
		ivec4 boneindex;
		vec4  boneweight;
	};

	class md5_loader : public mesh_loader
	{
	public:
		enum file_type { UNKNOWN, MESH, ANIMATION };

		explicit md5_loader( string_table* strings ) : mesh_loader( strings ), m_type( UNKNOWN ), m_nodes( nullptr ) {}
		virtual ~md5_loader();
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual size_t get_nodes_data_count() const { return 1; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }

		struct md5_weight
		{
			size_t joint_id;
			float  bias;
			vec3   pos;
		};

	protected:
		struct md5_joint_info
		{
			int         flags;
			size_t      start_index;
		};

		struct md5_weight_info
		{
			size_t     start_weight;
			size_t     weight_count;
		};

	protected:
		void reset();
		void build_frame_skeleton( mesh_node_data* nodes, uint32 index, const array_view<md5_joint_info>& joint_info, const array_view<transform>& base_frames, const array_view<float>& frame_data );
		bool prepare_mesh( mesh_node_data* nodes, uint32 vtx_count, data_channel_set* mdata, md5_weight* weights, md5_weight_info* weight_info );
	protected:
		file_type m_type;
		uint32 m_md5_version;
		mesh_nodes_data* m_nodes;
		dynamic_array<data_channel_set*> m_meshes;
	};

}

#endif // NV_FORMATS_MD5_LOADER_HH
