// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_INTERFACE_DATA_CHANNEL_ACCESS_HH
#define NV_INTERFACE_DATA_CHANNEL_ACCESS_HH

#include <nv/common.hh>
#include <nv/interface/data_channel.hh>

namespace nv
{


	class raw_data_channel_access
	{
	public:
		explicit raw_data_channel_access( raw_data_channel* channel )
		{
			m_channel = channel;
		}

		raw_data_channel_access( data_channel_set* set, uint32 index )
		{
			m_channel = &set->m_channels[index];
		}

		uint32 element_size() const { return m_channel->element_size(); }
		uint32 size() const { return m_channel->size(); }
		uint32 raw_size() const { return m_channel->size() * m_channel->element_size(); }
		uint8* raw_data() { return m_channel->m_data; }
		const uint8* raw_data() const { return m_channel->m_data; }
		raw_data_channel* channel() { return m_channel; }

		data_descriptor& descriptor() { return m_channel->m_desc; }
		const data_descriptor& descriptor() const { return m_channel->m_desc; }
	protected:
		raw_data_channel* m_channel;
	};

	template < typename Struct >
	class data_channel_access : public raw_data_channel_access
	{
	public:

		// TODO - descriptor check
		explicit data_channel_access( raw_data_channel* channel )
			: raw_data_channel_access( channel )
		{
		}
		data_channel_access( data_channel_set* set, uint32 index )
			: raw_data_channel_access( set, index )
		{
		}

		Struct* data() { return reinterpret_cast<Struct*>( m_channel->m_data ); }
		const Struct* data() const { return reinterpret_cast<const Struct*>( m_channel->m_data ); }

		const Struct& operator []( uint32 i ) const
		{
			NV_ASSERT( i < m_channel->m_size, "data_channel_creator indexing failure!" );
			return reinterpret_cast<const Struct*>( m_channel->m_data )[i];
		}

		Struct& operator []( uint32 i )
		{
			NV_ASSERT( i < m_channel->m_size, "data_channel_creator indexing failure!" );
			return reinterpret_cast<Struct*>( m_channel->m_data )[i];
		}
	};

	class data_channel_creator
	{
	public:
		template< typename Struct >
		static raw_data_channel create( uint32 size )
		{
			raw_data_channel channel;
			channel.m_desc = data_descriptor::create< Struct >();
			channel.m_size = size;
			channel.m_data = ( size > 0 ? ( new uint8[channel.raw_size()] ) : nullptr );
			return channel;
		}

		static raw_data_channel create( const data_descriptor& desc, uint32 size )
		{
			raw_data_channel channel;
			channel.m_desc = desc;
			channel.m_size = size;
			channel.m_data = ( size > 0 ? ( new uint8[channel.raw_size()] ) : nullptr );
			return channel;
		}
	};


	class data_channel_set_creator
	{
		typedef data_channel_set::const_iterator const_iterator;
	public:

		static data_channel_set* create_set( size_t )
		{
			return new data_channel_set;
		}

		static data_channel_set* create_set_array( size_t size, size_t )
		{
			return new data_channel_set[ size ];
		}

		explicit data_channel_set_creator( data_channel_set* set ) : m_set( set ) {}

		void set_channel( uint32 i, raw_data_channel&& channel )
		{
			m_set->m_channels[i] = move( channel );
		}

		template < typename Struct >
		data_channel_access< Struct > add_channel( uint32 size )
		{
			raw_data_channel channel = data_channel_creator::create( data_descriptor::create< Struct >(), size );
			uint32 index = m_set->m_size;
			m_set->m_channels[index] = move( channel );
			m_set->m_size++;
			return data_channel_access< Struct >( &m_set->m_channels[index] );
		}
		
		raw_data_channel_access add_channel( const data_descriptor& desc, uint32 size )
		{
			raw_data_channel channel = data_channel_creator::create( desc, size );
			uint32 index = m_set->m_size;
			m_set->m_channels[index] = move( channel );
			m_set->m_size++;
			return raw_data_channel_access( &m_set->m_channels[ index ] );
		}

		raw_data_channel* operator []( uint32 i ) const { return &m_set->m_channels[i]; }
		const_iterator begin() const { return m_set->begin(); }
		const_iterator end()   const { return m_set->end(); }

		void set_name( const char* /*name*/ ) {}// { m_name = name; }
													   //const std::string& get_name() const { return m_name; }

		void move_to( data_channel_set& other )
		{
			int change_to_move;
			//			other.m_name          = m_name;
			for ( uint32 c = 0; c < m_set->m_size; ++c )
			{
//				if ( other.m_channels[c] ) delete other.m_channels[c];
				other.m_channels[c] = move( m_set->m_channels[c] );
			}
			other.m_name = m_set->m_name;
			other.m_parent_id = m_set->m_parent_id;
			other.m_transform = m_set->m_transform;
			other.m_size = m_set->m_size;
			m_set->m_size = 0;
		}

		void set_transform( const mat4& tr ) { m_set->m_transform = tr; }
		const mat4& get_transform() const { return m_set->m_transform; }

		void set_name( uint64 name ) {  m_set->m_name = name; }
		uint64 get_name() const { return m_set->m_name; }

		void set_parent_id( sint16 name ) { m_set->m_parent_id = name; }
		sint16 get_parent_id() const { return m_set->m_parent_id; }
	protected:
		data_channel_set* m_set;
	};


}

#endif // NV_INTERFACE_DATA_CHANNEL_ACCESS_HH
