// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_FORMATS_NMD_LOADER_HH
#define NV_FORMATS_NMD_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/stl/vector.hh>
#include <nv/io/string_table.hh>

namespace nv 
{

	enum class nmd_type : uint16
	{
		MESH,
		ANIMATION,
		NODE,
		STRINGS,
		DATA
	};

	struct nmd_header
	{
		uint32 id;
		uint32 version;
		uint32 elements;
		uint32 attributes;
	};

	enum class nmd_datatype : uint16
	{
		STRING,
		INTEGER,
		FLOAT
	};

	struct nmd_attribute
	{
		uint64       key;
		uint8        data[22];
		nmd_datatype type;
	};
	static_assert( sizeof( nmd_attribute ) == 32, "alignment issue!" );


	struct nmd_element_header
	{
		nmd_type type;
		uint16   children;
		uint32   size;
		uint64   name_hash;
		mat4     transform;
		sint16   parent_id;
		uint16   attributes;
	};

	struct nmd_animation_header
	{
		uint16 frame_rate;
		float  duration;
		bool   flat;
	};

	struct nmd_channel_header
	{
		data_descriptor format;
		uint32          count;
	};

	class nmd_loader : public mesh_loader
	{
	public:
		nmd_loader() : m_node_data( nullptr ), m_node_array( nullptr ) {} //, m_strings( nullptr ) {}
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual size_t get_nodes_data_count() const { return 1; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
		virtual ~nmd_loader();
	private:
		void reset();
		void skip_attributes( stream& source, uint32 count );
		bool load_mesh( stream& source, const nmd_element_header& e );
		bool load_strings( stream& source ); 
		bool load_animation( stream& source, const nmd_element_header& e );
		bool load_node( stream& source, mesh_node_data* data, const nmd_element_header& e );
		bool load_channel( stream& source, data_channel_set* channel_set );
		bool load_channel_set( stream& source, data_channel_set* channel_set, const nmd_element_header& e );

		mesh_nodes_data*            m_node_data;
		mesh_node_data*             m_node_array;
//		string_table*               m_strings;
//		vector< uint16 >            m_mesh_names;
//		vector< uint16 >            m_node_names;
		vector< data_channel_set* > m_meshes;
	};

	// HACK : TEMPORARY - will go to it's own file, probably nmd_io
	void nmd_dump( const nv::mesh_data_pack* model, stream& stream_out );

}

#endif // NV_FORMATS_NMD_LOADER_HH
