// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_device.hh"

#include "nv/gl/gl_window.hh"
#include "nv/gl/gl_program.hh"
#include "nv/gl/gl_vertex_buffer.hh"
#include "nv/logging.hh"
#include "nv/lib/sdl12.hh"

using namespace nv;

window* gl_device::create_window( uint16 width, uint16 height )
{
	return new gl_window( width, height );
}

gl_device::gl_device()
{
	nv::load_sdl_library();
	m_info = NULL;

	if ( SDL_Init( SDL_INIT_VIDEO ) < 0 )
	{
		NV_LOG( LOG_CRITICAL, "Video initialization failed: " << SDL_GetError( ) );
		return; // TODO: Error report
	}

	m_info = SDL_GetVideoInfo( );

	if ( !m_info )
	{
		NV_LOG( LOG_CRITICAL, "Video query failed: " << SDL_GetError( ) );
		return; // TODO: Error report
	}

//	bpp = m_info->vfmt->BitsPerPixel;

	SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
}

program* gl_device::create_program( const string& vs_source, const string& fs_source )
{
	return new gl_program( vs_source, fs_source );
}

vertex_buffer* gl_device::create_vertex_buffer( buffer_hint hint, int size, void* source /*= nullptr */ )
{
	return new gl_vertex_buffer( hint, size, source );
}

gl_device::~gl_device()
{
	SDL_Quit();
}

