// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_INTERFACE_MESH_LOADER_HH
#define NV_INTERFACE_MESH_LOADER_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/string.hh>
#include <nv/gfx/animation.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/stream.hh>

namespace nv 
{

	class mesh_loader
	{
	public:
		mesh_loader() {}
		virtual ~mesh_loader() {}
		virtual bool load( stream& source ) = 0;
		virtual data_channel_set* release_mesh_data( size_t index = 0 ) = 0;
		virtual mesh_data_pack* release_mesh_data_pack() = 0;
		virtual size_t get_mesh_count() const = 0;
		virtual size_t get_nodes_data_count() const { return 0; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 ) { return nullptr; }
	};

}

#endif // NV_INTERFACE_MESH_LOADER_HH

