// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_FORMATS_OBJ_LOADER_HH
#define NV_FORMATS_OBJ_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/stl/vector.hh>

namespace nv 
{

	class obj_loader : public mesh_loader
	{
	public:
		obj_loader( bool normals = true, bool tangents = false );
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
		~obj_loader();
	private:
		data_descriptor             m_descriptor;
		bool                        m_normals;
		bool                        m_tangents;
		vector< data_channel_set* > m_meshes;
	};

}

#endif // NV_FORMATS_OBJ_LOADER_HH
