// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_FORMATS_ASSIMP_LOADER_HH
#define NV_FORMATS_ASSIMP_LOADER_HH

#include <nv/common.hh>
#include <nv/io/string_table.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/animated_mesh.hh>

namespace nv 
{

	class assimp_loader : public mesh_loader
	{
	public:
		explicit assimp_loader( const std::string& a_ext, uint32 a_assimp_flags = 0 );
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual size_t get_mesh_count() const { return m_mesh_count; }
		virtual ~assimp_loader();
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_nodes_data_count() const;
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t index = 0 );
		void scene_report() const;
	private:
		mesh_nodes_data* release_merged_bones( data_channel_set* meshes );
		bool load_bones( size_t index, array_ref< mesh_node_data > bones );
		void load_mesh_data( data_channel_set* data, size_t index );
		sint16 load_node( uint32 anim_id, mesh_node_data* nodes, const void* vnode, sint16 this_id, sint16 parent_id );
		uint32 count_nodes( const void* node ) const;
		void create_keys( mesh_node_data* data, const void* vnode );

		string_table_creator m_strings;
		std::string m_ext;
		uint32 m_assimp_flags;
		const void* m_scene;
		size_t m_mesh_count;
	};

}

#endif // NV_FORMATS_ASSIMP_LOADER_HH
