// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#define NV_BASE_COMMON_HH
#define NV_INTERNAL_INCLUDE
#include "nv/base/assert.hh"
#undef NV_BASE_COMMON_HH
#include "nv/core/logging.hh"

extern "C" {
#if NV_COMPILER == NV_MSVC
	NV_NORETURN void __cdecl exit( _In_ int _Code );
#else
	void exit( int status_code ) NV_NORETURN;
#endif
}

#if NV_DEBUG
#	if NV_COMPILER == NV_MSVC
extern "C" {
	void __cdecl _wassert( const wchar_t * _Message, const wchar_t *_File, unsigned _Line );
}

void nv::detail::assert_fail( const wchar_t * message, const wchar_t* file, unsigned line )
{
	_wassert( message, file, line );
}
#	else // NV_COMPILER
#	if NV_COMPILER == NV_CLANG
extern "C" {
	extern void __assert(const char *, const char *, unsigned int, const char *) NV_NORETURN;
}
#define NV_ASSERT_IMPL __assert
#	else
extern "C" {
	extern void __assert_fail(const char *, const char *, unsigned int, const char *) NV_NORETURN;
}
#define NV_ASSERT_IMPL __assert_fail
#	endif
NV_NORETURN void nv::detail::assert_fail( const char * assertion, const char * file, unsigned int line, const char * function )
{
	NV_ASSERT_IMPL (assertion, file, line, function );
}
#	endif

#endif // NV_DEBUG

NV_NORETURN void nv::detail::abort( const char * msg, const char * file, unsigned int line, const char * function )
{
	NV_LOG_CRITICAL( "Abort called : ", msg );
	NV_LOG_CRITICAL( "  in ", file, ":", line, " (", function, ")" );
	NV_LOG_CRITICAL( "Aborting..." );
	exit( 1 );
}

NV_NORETURN void nv::detail::assert_abort( const char * msg, const char * file, unsigned int line, const char * function )
{
	NV_LOG_CRITICAL( "Assertion failed: (", msg, ")" );
	NV_LOG_CRITICAL( "  in ", file, ":", line, " (", function, ")" );
	NV_LOG_CRITICAL( "Aborting..." );
	exit( 1 );
}


NV_NORETURN void nv::exit( int ret_val )
{
	::exit( ret_val );
}
