// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file unordered_map.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief unordered_map
 */

#ifndef NV_STL_UNORDERED_MAP_HH
#define NV_STL_UNORDERED_MAP_HH

#include <nv/common.hh>
#include <nv/stl/container/hash_table.hh>
#include <nv/stl/utility/pair.hh>

namespace nv
{

	template <
		typename Key, 
		typename T,
		typename Hash = hash< Key >,
		typename KeyEqual = equal_to< Key >
//		typename Hash = hash<Key>(), 
//		typename Predicate = equal_to<Key>,
	>
	class unordered_map
		: public hash_table< hash_table_entry_stl_map< Key, T, size_t, KeyEqual, Hash > >
	{
	public:
		typedef hash_table< hash_table_entry_stl_map< Key, T, size_t, KeyEqual, Hash > > base_type;
		typedef unordered_map< Key, T, Hash, KeyEqual >                                  this_type;
		typedef typename base_type::value_type                                           value_type;
		typedef typename base_type::pointer                                              pointer;
		typedef typename base_type::const_pointer                                        const_pointer;
		typedef typename base_type::reference                                            reference;
		typedef typename base_type::const_reference                                      const_reference;
		typedef typename base_type::iterator                                             iterator;
		typedef typename base_type::const_iterator                                       const_iterator;
		typedef typename base_type::size_type                                            size_type;
		typedef typename base_type::difference_type                                      difference_type;
		typedef typename base_type::key_type                                             key_type;
		typedef typename base_type::mapped_type                                          mapped_type;
		typedef typename base_type::node_type                                            node_type;
		typedef typename base_type::insert_return_type                                   insert_return_type;
		typedef Hash                                                                     hasher;
		typedef KeyEqual                                                                 key_equal;

		unordered_map() : base_type() { }
		explicit unordered_map( size_type bucket_count ) : base_type( bucket_count ) { }

		mapped_type& operator[]( const key_type& key )
		{
			return ( *base_type::insert_key( key ).first ).second;
		}

		using base_type::insert;
	
		// STL compatibility only, hint unused
		iterator insert( const_iterator, const value_type& value )
		{
			return base_type::insert( value ).first;
		}

	};

}

#endif // NV_STL_UNORDERED_MAP_HH

