// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file assert.hh
 * @author Kornel Kisielewicz
 * @brief Assert functions
 */

#ifndef NV_BASE_COMMON_HH
#error "Do not include assert.hh directly, inlcude nv/common.hh"
#endif

#ifndef NV_BASE_ASSERT_HH
#define NV_BASE_ASSERT_HH

#ifdef NV_INTERNAL_INCLUDE
#undef NV_BASE_COMMON_HH
#include <nv/core/common.hh>
#endif

#if NV_COMPILER == NV_MSVC
void nv_internal_assert( const wchar_t * message, const wchar_t* file, unsigned line );
#	if NV_DEBUG
#	define NV_ASSERT_IMPL(cond) (void)( (!!(cond)) || (nv_internal_assert(NV_WIDE(#cond), NV_WIDE(__FILE__), __LINE__), 0) )
#	else
#	define NV_ASSERT_IMPL(cond) 
#	endif
#else
void nv_internal_assert( const char * assertion, const char * file, unsigned int line, const char * function );
#	if NV_DEBUG
#	define NV_ASSERT_IMPL(cond) ((cond) ? static_cast<void>(0) : nv_internal_assert(NV_STRINGIZE(cond), __FILE__, __LINE__, __PRETTY_FUNCTION__))
#	else
#	define NV_ASSERT_IMPL(cond) 
#	endif
#endif

#if NV_DEBUG
#define NV_ASSERT(cond, msg) NV_ASSERT_IMPL( (cond) && "assertion failed:" msg )
#else  
#define NV_ASSERT(cond, msg)     ((void)0)
#endif 

#endif // NV_BASE_ASSERT_HH
