// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file input.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief input interface
 */

#ifndef NV_INTERFACE_INPUT_HH
#define NV_INTERFACE_INPUT_HH

#include <nv/common.hh>
#include <nv/core/io_event.hh>

namespace nv
{

	class input
	{
	public:
		virtual bool is_event_pending() = 0;
		virtual bool poll_event( io_event& event ) = 0;
		virtual ~input() {}
	};

}

#endif // NV_INTERFACE_INPUT_HH