// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_GL_FONT_HH
#define NV_GL_FONT_HH

#include <nv/core/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/unordered_map.hh>

namespace nv
{
	struct gylph
	{
	    uint16 charcode;
		ivec2 size;
	    ivec2 offset;
	    vec2 advance;
	    vec2 tl;
	    vec2 br;
		unordered_map< uint16, float > kerning;

		gylph();
		float get_kerning( const uint16 cc );
	};

	class font
	{
	public:
		const gylph* get_gylph( uint16 charcode ) const;
	private:
		unordered_map< uint16, gylph > m_gylphs;
	};


}

#endif // NV_GL_FONT_HH
