// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_NMD_LOADER_HH
#define NV_NMD_LOADER_HH

#include <nv/core/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/stl/vector.hh>
#include <nv/io/string_table.hh>

namespace nv 
{

	enum class nmd_type : uint16
	{
		MESH,
		STREAM,
		NODE,
		STRING_TABLE,
		ANIMATION,
		KEY_CHANNEL,
	};

	struct nmd_header
	{
		uint32 id;
		uint32 version;
		uint32 elements;
	};

	struct nmd_element_header
	{
		nmd_type type;
		uint16   name;
		uint16   children;
		uint32   size;
	};

	struct nmd_animation_header
	{
		uint16 frame_rate;
		float  duration;
		bool   flat;
	};

	struct nmd_node_header
	{
		sint16 parent_id;
		mat4   transform;
	};

	struct nmd_key_channel_header
	{
		key_descriptor format;
		uint32         count;
	};

	struct nmd_stream_header
	{
		vertex_descriptor format;
		uint32 count;
	};

	class nmd_loader : public mesh_loader
	{
	public:
		nmd_loader() : m_node_data( nullptr ), m_node_array( nullptr ), m_strings( nullptr ) {}
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual size_t get_nodes_data_count() const { return 1; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
		virtual ~nmd_loader();
	private:
		void reset();
		bool load_mesh( stream& source, const nmd_element_header& e );
		bool load_strings( stream& source ); 
		bool load_animation( stream& source, const nmd_element_header& e );

		mesh_nodes_data*          m_node_data;
		mesh_node_data*           m_node_array;
		string_table*             m_strings;
		vector< uint16 >          m_mesh_names;
		vector< uint16 >          m_node_names;
		vector< mesh_data* >      m_meshes;
	};

	// HACK : TEMPORARY - will go to it's own file, probably nmd_io
	void nmd_dump( const nv::mesh_data_pack* model, stream& stream_out );

}

#endif // NV_NMD_LOADER_HH
