// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file map_area.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 */

#ifndef NV_MAP_AREA_HH
#define NV_MAP_AREA_HH

#include <nv/core/common.hh>
#include <nv/core/position.hh>
#include <nv/stl/string.hh>
#include <string>

namespace nv
{
	class map_sub_area;
	
	class map_area
	{
	public:
		virtual uint32 get_cell( const position& p ) const = 0;
		virtual void set_cell( const position& p, uint32 value ) = 0;
		virtual uint32 string_to_id( const std::string& ) const { return 0; }
		virtual std::string id_to_string( uint32 ) const { return std::string(); }
		virtual dimension get_size() const = 0;
		virtual position get_shift() const { return position(); }
		virtual rectangle get_rectangle() const { return rectangle( get_shift(), get_shift() + get_size() ); }
		virtual map_area* create_sub_area( const rectangle& area );
		virtual bool is_visible( const position& ) const { return true; }
		virtual bool is_explored( const position& ) const { return true; }
		virtual void set_visible( const position&, bool ) {}
		virtual bool is_transparent( const position& ) const { return true; }
		virtual ~map_area(){}
	};

	class map_sub_area : public map_area
	{
	public:
		map_sub_area( map_area* source, const rectangle& area ) : m_map_area( source ), m_area( area ) {}
		virtual uint32 get_cell( const position& p ) const { return m_map_area->get_cell( m_area.ul + p ); }
		virtual void set_cell( const position& p, uint32 value ) { m_map_area->set_cell( m_area.ul + p, value ); }
		virtual dimension get_size() const { return m_area.get_size(); }
		virtual position get_shift() const { return m_area.ul + m_map_area->get_shift(); }
		virtual uint32 string_to_id( const std::string& s ) const { return m_map_area->string_to_id( s ); }
		virtual std::string id_to_string( uint32 id ) const { return m_map_area->id_to_string( id ); }
	private:
		map_area* m_map_area;
		rectangle m_area;
	};

	inline map_area* map_area::create_sub_area( const rectangle& area ) 
	{ 
		return new map_sub_area( this, area ); 
	}

}

#endif // NV_MAP_AREA_HH