// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file growing_container_handler.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief growing contiguous container handler
*/

#ifndef NV_STL_CONTAINER_GROWING_CONTAINER_HANDLER_HH
#define NV_STL_CONTAINER_GROWING_CONTAINER_HANDLER_HH

#include <nv/core/common.hh>
#include <nv/stl/container/initialize_policy.hh>
#include <nv/stl/container/sized_container_handler.hh>

namespace nv
{

	template <
		typename Storage,
		typename InitializePolicy = policy_initialize_standard
	>
	class growing_container_handler : public sized_container_handler< Storage, InitializePolicy >
	{
		typedef sized_container_handler< Storage, InitializePolicy > inherited;
	public:
		typedef typename Storage::value_type value_type;
		typedef typename Storage::size_type  size_type;

		using sized_container_handler< Storage, InitializePolicy >::sized_container_handler;

		void reserve( size_type new_capacity )
		{
			Storage::try_reserve( new_capacity, true );
		}
		void push_back( const value_type& e )
		{
			if ( Storage::try_grow( 1 ) ) copy_construct_object( data() + size() - 1, e );
		}
		void push_back( value_type&& e )
		{
			if ( Storage::try_grow( 1 ) ) move_construct_object( data() + size() - 1, forward<value_type>( e ) );
		}
		template < typename... Args >
		void emplace_back( Args&&... args )
		{
			if ( Storage::try_grow( 1 ) ) construct_object( data() + size() - 1, forward<Args>( args )... );
		}
		void pop_back()
		{
			try_resize( size() - 1, true );
		}

	};

}

#endif // #define NV_STL_CONTAINER_GROWING_CONTAINER_HANDLER_HH

