// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file contiguous.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief exception free contiguous base classes
*/

#ifndef NV_STL_CONTAINER_CONTIGUOUS
#define NV_STL_CONTAINER_CONTIGUOUS

#include <nv/core/common.hh>
#include <nv/stl/memory.hh>
#include <nv/stl/iterator.hh>
#include <nv/stl/utility.hh>
#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/contiguous_storage_policy.hh>
#include <nv/stl/container/initialize_policy.hh>

namespace nv
{

	template < typename ContainerAllocator >
	using array_base_t = detail::add_random_access< detail::add_iterators < ContainerAllocator > >;

}

#endif // NV_STL_CONTAINER_CONTIGUOUS
